clear all
set more off

cd "..\Processed Data"


use Employment.dta, clear


gen YYYY=substr(date,1,4)
destring YYYY, force replace

gen MM=substr(date,6,2)
destring MM, force replace


gen DD=substr(date,9,2)
destring DD, force replace

gen DATE3=mdy(MM,DD,YYYY)
	format DATE3 %td


joinby YYYY MM SubnationalClean using RegionalCPI.dta, unmatched(both)
tab YYYY _merge
tab SubnationalClean _merge

/*
joinby YYYY MM subnationalclean using CPI_services.dta, unmatched(both)
tab YYYY _merge
tab subnationalclean _merge
*/


drop  _merge

joinby YYYY MM SubnationalClean using Population.dta, unmatched(both)
tab YYYY _merge
tab SubnationalClean _merge


egen ID=group(SubnationalClean)
tsset ID date3

tsset ID date3
by ID: ipolate Population DATE3, generate(Population3) epolate

gen EPOP=unit/Population3*1000

egen TT=group(YYYY MM)
tsset ID TT

gen time=YYYY+(MM-1)/12

gen dEMP=log(value/ l12.value)*100

gen temp_EMP=value if time==2022
egen temp_EMP2=mean(temp_EMP), by(ID)

gen dcumEMP=log(value/temp_EMP2)*100


by ID: ipolate EPOP DATE3, generate(EPOP3)



egen temp_EPOP3=mean(EPOP3) if time<2022 & time>=2014, by(ID)
egen temp_EPOP3A=mean(temp_EPOP3), by(ID)

gen deviation_EPOP3=EPOP3- temp_EPOP3A

egen temp_EMPX=mean(log(unit)) if time<2022 & time>=2014, by(ID)
egen temp_EMPA=mean(temp_EMPX), by(ID)

gen deviation_EMP=log(unit)-  temp_EMPA

/*
gen EPOP3_hp=.
sum ID
local rmax=r(max)
forvalues i=1(1)`rmax' {
	noisily di `i'
	capture drop temp_hp
	tsfilter hp temp_hp = EPOP3 if ID==`i' & EPOP3~=., smooth(1000000) 
	replace EPOP3_hp=temp_hp if ID==`i'

}
*/

gen CPI_YOY=indexYoY-100

compress

save step010_v2, replace


